% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_data_validation}
\alias{wb_add_data_validation}
\title{Add data validation to cells in a worksheet}
\usage{
wb_add_data_validation(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  type,
  operator,
  value,
  allow_blank = TRUE,
  show_input_msg = TRUE,
  show_error_msg = TRUE,
  error_style = NULL,
  error_title = NULL,
  error = NULL,
  prompt_title = NULL,
  prompt = NULL,
  ...
)
}
\arguments{
\item{wb}{A Workbook object}

\item{sheet}{A name or index of a worksheet}

\item{dims}{A cell dimension ("A1" or "A1:B2")}

\item{type}{One of 'whole', 'decimal', 'date', 'time', 'textLength', 'list'
(see examples)}

\item{operator}{One of 'between', 'notBetween', 'equal',
'notEqual', 'greaterThan', 'lessThan', 'greaterThanOrEqual', 'lessThanOrEqual'}

\item{value}{a vector of length 1 or 2 depending on operator (see examples)}

\item{allow_blank}{logical}

\item{show_input_msg}{logical}

\item{show_error_msg}{logical}

\item{error_style}{The icon shown and the options how to deal with such inputs.
Default "stop" (cancel), else "information" (prompt popup) or
"warning" (prompt accept or change input)}

\item{error_title}{The error title}

\item{error}{The error text}

\item{prompt_title}{The prompt title}

\item{prompt}{The prompt text}

\item{...}{additional arguments}
}
\description{
Add Excel data validation to cells
}
\examples{
wb <- wb_workbook()
wb$add_worksheet("Sheet 1")
wb$add_worksheet("Sheet 2")

wb$add_data_table(1, x = iris[1:30, ])
wb$add_data_validation(1,
  dims = "A2:C31", type = "whole",
  operator = "between", value = c(1, 9)
)
wb$add_data_validation(1,
  dims = "E2:E31", type = "textLength",
  operator = "between", value = c(4, 6)
)

## Date and Time cell validation
df <- data.frame(
  "d" = as.Date("2016-01-01") + -5:5,
  "t" = as.POSIXct("2016-01-01") + -5:5 * 10000
)
wb$add_data_table(2, x = df)
wb$add_data_validation(2, dims = "A2:A12", type = "date",
  operator = "greaterThanOrEqual", value = as.Date("2016-01-01")
)
wb$add_data_validation(2,
  dims = "B2:B12", type = "time",
  operator = "between", value = df$t[c(4, 8)]
)


######################################################################
## If type == 'list'
# operator argument is ignored.

wb <- wb_workbook()
wb$add_worksheet("Sheet 1")
wb$add_worksheet("Sheet 2")

wb$add_data_table(sheet = 1, x = iris[1:30, ])
wb$add_data(sheet = 2, x = sample(iris$Sepal.Length, 10))

wb$add_data_validation(1, dims = "A2:A31", type = "list", value = "'Sheet 2'!$A$1:$A$10")
}
