% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_formula}
\alias{write_formula}
\title{Write a character vector as an Excel Formula}
\usage{
write_formula(
  wb,
  sheet,
  x,
  dims = wb_dims(start_row, start_col),
  start_col = 1,
  start_row = 1,
  array = FALSE,
  cm = FALSE,
  apply_cell_style = TRUE,
  remove_cell_style = FALSE,
  enforce = FALSE,
  ...
)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet.}

\item{sheet}{The worksheet to write to. (either as index or name)}

\item{x}{A formula as character vector.}

\item{dims}{Spreadsheet dimensions that will determine where \code{x} spans: "A1", "A1:B2", "A:B"}

\item{start_col}{A vector specifying the starting column to write to.}

\item{start_row}{A vector specifying the starting row to write to.}

\item{array}{A bool if the function written is of type array}

\item{cm}{A special kind of array function that hides the curly braces in the cell.
Add this, if you see "@" inserted into your formulas.}

\item{apply_cell_style}{Should we write cell styles to the workbook?}

\item{remove_cell_style}{Should we keep the cell style?}

\item{enforce}{enforce dims}

\item{...}{additional arguments}
}
\description{
Write a a character vector containing Excel formula to a worksheet.
Use \code{\link[=wb_add_formula]{wb_add_formula()}} or \code{add_formula()} in new code. This function is meant
for internal use.
}
\keyword{internal}
