% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lpsymphony_solver.R
\name{add_lsymphony_solver}
\alias{add_lsymphony_solver}
\alias{add_lpsymphony_solver}
\title{Add a SYMPHONY solver with \pkg{lpsymphony}}
\usage{
add_lpsymphony_solver(x, gap = 0, time_limit = -1,
  first_feasible = 0, verbose = TRUE)
}
\arguments{
\item{x}{\code{\link{ProjectProblem-class}} object.}

\item{gap}{\code{numeric} gap to optimality. This gap is relative when
solving problems using \pkg{gurobi}, and will cause the optimizer to
terminate when the difference between the upper and lower objective
function bounds is less than the gap times the upper bound. For example, a
value of 0.01 will result in the optimizer stopping when the difference
between the bounds is 1 percent of the upper bound. For
other solvers, this is the absolute gap, so if the optimal value for
a maximization problem is 10, a gap of 0.01 means that a solution between
10 and 10.01 is required. Defaults to 0, so that optimal solutions will be
returned.}

\item{time_limit}{\code{numeric} time limit in seconds to run the optimizer.
The solver will return the current best solution when this time limit is
exceeded.}

\item{first_feasible}{\code{logical} should the first feasible solution be
be returned? If \code{first_feasible} is set to \code{TRUE}, the solver
will return the first solution it encounters that meets all the
constraints, regardless of solution quality. Note that the first feasible
solution is not an arbitrary solution, rather it is derived from the
relaxed solution, and is therefore often reasonably close to optimality.
Defaults to \code{FALSE}.}

\item{verbose}{\code{logical} should information be printed while solving
optimization problems?}
}
\value{
\code{\link{ProjectProblem-class}} object with the solver added
  to it.
}
\description{
Specify that the \emph{SYMPHONY} software should be used to solve a
project prioritization \code{\link{problem}} using the \pkg{lpsymphony}
package. This function can also be used to customize the behavior of the
solver. It requires the \pkg{lpsymphony} package.
}
\details{
\href{https://projects.coin-or.org/SYMPHONY}{\emph{SYMPHONY}} is an
  open-source integer programming solver that is part of the Computational
  Infrastructure for Operations Research (COIN-OR) project, an initiative
  to promote development of open-source tools for operations research (a
  field that includes linear programming). The \pkg{lpsymphony} package is
  distributed through
  \href{https://doi.org/doi:10.18129/B9.bioc.lpsymphony}{Bioconductor}.
  This functionality is provided because the \pkg{lpsymphony} package may
  be easier to install to install on Windows and Mac OSX systems than the
  \pkg{Rsymphony} package.
}
\examples{
\donttest{
# load data
data(sim_projects, sim_features, sim_actions)

# build problem with lpsymphony solver
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 200) \%>\%
     add_binary_decisions() \%>\%
     add_lpsymphony_solver()

# print problem
print(p)

# solve problem
s <- solve(p)

# print solution
print(s)

# plot solution
plot(p, s)
}
}
\seealso{
\code{\link{solvers}}.
}
