% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opticskxi.R
\name{opticskxi}
\alias{opticskxi}
\title{OPTICS k-Xi clustering algorithm}
\usage{
opticskxi(
  optics_obj,
  n_xi,
  pts = optics_obj$minPts,
  max_loop = 50,
  verbose = FALSE
)
}
\arguments{
\item{optics_obj}{Data frame returned by optics}

\item{n_xi}{Number of clusters to define}

\item{pts}{Minimum number of points per clusters}

\item{max_loop}{Maximum iterations to find n_xi clusters}

\item{verbose}{Print the ids of the largest difference considered and
cluster information if they define one}
}
\value{
Vector of clusters
}
\description{
For each largest distance differences on the OPTICS profile,
consecutive observations left and right on the OPTICS profile
(i.e. lower and higher OPTICS id) will be assigned to 2 different clusters
if their distance is below the distance of the edge point.
If above, observations are NA.
The pts parameter defines a minimum number of observations to form a
valley (i.e. cluster). If the number of observations in one valley is
smaller than pts, observations are set to NA.
}
\examples{
data('multishapes')
optics_shapes <- dbscan::optics(multishapes[1:2])
kxi_shapes <- opticskxi(optics_shapes, n_xi = 5, pts = 30)
ggplot_optics(optics_shapes, groups = kxi_shapes)
ggpairs(cbind(multishapes[1:2], kXi = kxi_shapes), group = 'kXi')
}
\seealso{
\link{opticskxi_pipeline}, \link{ggplot_optics}
}
