% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psych_kxi_example.R
\name{psych_kxi_pipeline}
\alias{psych_kxi_pipeline}
\title{Example pipeline for mental health natural language processing}
\usage{
psych_kxi_pipeline(
  m_data,
  df_params = expand.grid(n_xi = 8:15, pts = c(15, 20, 25, 30), dist = "cosine", dim_red
    = "ICA", n_dimred_comp = c(10, 15, 20, 25)),
  max_size_ratio = 0.15,
  n_min_clusters = 5,
  n_cores = 1
)
}
\arguments{
\item{m_data}{Data matrix}

\item{df_params}{Parameter grid for the OPTICS k-Xi function call and
optional dimension reduction.
Required columns: n_xi, pts, dist.
Optonal columns: dim_red, n_dim_red.}

\item{max_size_ratio}{Maximum size ratio of clusters}

\item{n_min_clusters}{Minimum number of clusters}

\item{n_cores}{Number of cores}
}
\value{
Input parameter data frame with with results binded in columns
        optics, clusters and metrics.
}
\description{
Removes too large clusters and models with less than a minimum number of
clusters.
}
