% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/opt_get_verb.R
\name{opt_get_verb}
\alias{opt_get_verb}
\title{Get verb from the command line}
\usage{
opt_get_verb(opts = commandArgs())
}
\arguments{
\item{opts}{character; Vector from which to parse options
       (default: \code{commandArgs()} )}
}
\value{
character of length 1; the verb found from the command-line.
\code{NA} if a verb cannot be identified.
}
\description{
Return the verb for the application. The verb is the first argument that is
not part of an option.
}
\details{
Some applications such as \emph{git} support commend verbs, e.g. \code{push},
\code{fetch}, etc. These can be retrieved by \code{opt_get_verb}.

\code{opt_get_verb} look for the first unaccounted for options (after
\code{--args}). The number of options needed by each flags is determined by
and saved by calls to \code{\link{opt_get}}. See the details to see how
\code{n} is automatically determined.  When not explicitly defined the number
of options needed by each flag is 1.  Becasue of this, it convention to call
\code{opt_get_verb} after all \code{opt_get} calls.  For most simple
applications, it likely doesn't matter.
}
\section{Assumptions}{


\code{opt_get_verb} assumes any flags occurring before the verb have
exactly 1 value. A command line such as "> myscript --verbose verb" will be
misparsed; the code will assume that "verb" is the value of the
flag "--verbose"
}
\examples{
opt_get_verb()
}
\seealso{
\code{\link{opt_get}} \cr
  \code{\link{base}{commandArgs}}
}

