% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Optmatch.R
\name{optmatch_same_distance}
\alias{optmatch_same_distance}
\title{Checks if the distance \code{newdist} is identical to the distance used to
generate the optmatch object \code{obj}.}
\usage{
optmatch_same_distance(obj, newdist)
}
\arguments{
\item{obj}{An optmatch object.}

\item{newdist}{A distance}
}
\value{
Boolean whether the two distance specifications are identical.
}
\description{
To save space, optmatch objects merely store a hash of the distance matrix
instead of the original object. This checks if the hash of \code{newdist} is
identical to the hash currently saved in \code{obj}.
}
\details{
Note that the distance is hashed with its \code{call} set to
\code{NULL}. (This avoids issues where, for example, \code{match_on(Z~X,
data=d, caliper=NULL)} and \code{match_on(Z~x, data=d)} produce identical
matches (since the default argument to \code{caliper} is \code{NULL}) but
distinct calls.)
}
\author{
Josh Errickson
}

