\name{consider}
\alias{consider}
\title{Recommendations for Possible Merging of Clusters}
\description{Presents an ordered list of possible cluster combinations
to consider for merging to simplify a classification.
}
\usage{consider(part)
}
\arguments{
    \item{part}{an object of class \sQuote{partana} from functions
\code{partana}, \code{optpart} or \code{bestopt}}
}
\details{Simply sorts the cluster-to-cluster mean similarity matrix of a
\sQuote{partana} object into a list sorted by mean similarity.
}

\value{a data.frame with three elements:
   \item{row}{the current cluster number}
   \item{col}{the cluster to which it is most similar}
   \item{vals}{the mean similarity of the two clusters}
}
\references{\url{http://ecology.msu.montana.edu/labdsv/R}}
\note{The listed combinations are not suggested to be optimal by any specific
criterion.  In fact, if the \sQuote{partana} object was generated by \code{optpart} 
or \code{bestopt} it is known that the suggested combinations are sub-optimal.
Nevertheless, sometimes it is desirable to simplify a classification for other reasons.}
\author{
    David W. Roberts
    \email{droberts@montana.edu}
}
\seealso{\code{optpart}, \code{bestopt}
}
\examples{
    data(shoshveg)         # returns a vegetation data.frame
    dis.bc <- dsvdis(shoshveg,'bray') # calculates a Bray/Curtis
                                      # dissimilarity matrix
    opt.5 <- optpart(5,dis.bc)        # generates a 5 cluster partition
    consider(opt.5)       # recommends possible clusters to merge
}

\keyword{clustering}

