% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{orbital_json_read}
\alias{orbital_json_read}
\title{Read orbital json file}
\usage{
orbital_json_read(path)
}
\arguments{
\item{path}{file on disk.}
}
\value{
A orbital object
}
\description{
Read orbital json file
}
\examples{
\dontshow{if (rlang::is_installed(c("jsonlite", "recipes", "tidypredict", "workflows"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(workflows)
library(recipes)
library(parsnip)

rec_spec <- recipe(mpg ~ ., data = mtcars) \%>\%
  step_normalize(all_numeric_predictors())

lm_spec <- linear_reg()

wf_spec <- workflow(rec_spec, lm_spec)

wf_fit <- fit(wf_spec, mtcars)

orbital_obj <- orbital(wf_fit)

tmp_file <- tempfile()

orbital_json_write(orbital_obj, tmp_file)

orbital_json_read(tmp_file)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=orbital_json_write]{orbital_json_write()}}
}
