% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalForest-package.R
\name{ordinalForest-package}
\alias{ordinalForest-package}
\alias{ordinalForest}
\title{Ordinal Forests: Prediction and Variable Ranking with Ordinal Target Variables}
\description{
Ordinal forests (OF) are a method for ordinal regression with high-dimensional and low-dimensional 
data that is able to predict the values of the ordinal target variable for new observations 
based on a training dataset. Using a (permutation-based) variable importance measure it is moreover 
possible to rank the covariates with respect to their importances in the prediction of the values
of the ordinal target variable. \cr
OF will be presented in an upcoming technical report by Hornung et al..
}
\details{
For a detailed description of OF see: \code{\link{ordfor}}

The main functions are: \code{\link{ordfor}} (construction of OF) and
\code{\link{predict.ordfor}} (prediction of the target variable values of new observations).

NOTE: \pkg{ordinalForest} uses R code and C++ code from the R package \pkg{ranger} for the involved regression forests.
\pkg{ordinalForest} does, however, not depend on \pkg{ranger} or import \pkg{ranger}, because it was necessary to
copy the C++ code and parts of the R code from \pkg{ranger} to \pkg{ordinalForest} instead. The reason for this
is that \pkg{ranger}'s C++ code had to be altered in order to calculate a suitable permutation variable importance
measure for ordinal forests.
}
\examples{
\dontrun{
# Illustration of the key functionalities of the package:
##########################################################

# Load example dataset:

data(hearth)

# Inspect the data:
table(hearth$Class)
dim(hearth)

head(hearth) 


# Split into training dataset and test dataset:

set.seed(123)
trainind <- sort(sample(1:nrow(hearth), size=floor(nrow(hearth)*(2/3))))
testind <- setdiff(1:nrow(hearth), trainind)

datatrain <- hearth[trainind,]
datatest <- hearth[testind,]


# Construct OF using the training dataset:

ordforres <- ordfor(depvar="Class", data=datatrain, nsets=1000, ntreeperdiv=100, 
  ntreefinal=5000, perfmeasure = "equal")
ordforres

# Study variable importance values:
sort(ordforres$varimp, decreasing=TRUE)

# Take a closer look at the top variables:
boxplot(datatrain$oldpeak ~ datatrain$Class, horizontal=TRUE)
fisher.test(table(datatrain$exang, datatrain$Class))

# Predict values of the ordinal target variable in the test dataset:

preds <- predict(ordforres, newdata=datatest)
preds

# Compare predicted values with true values:
table(data.frame(true_values=datatest$Class, predictions=preds$ypred))
} 

}
