% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-unit-circle.r
\name{geom_unit_circle}
\alias{geom_unit_circle}
\title{Unit circle}
\usage{
geom_unit_circle(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  segments = 60,
  scale.factor = 1,
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{segments}{The number of segments to be used in drawing the circle.}

\item{scale.factor}{The circle radius; should remain at its default value 1
or passed the same value as \code{\link[=ggbiplot]{ggbiplot()}}. (This is an imperfect fix that
may be changed in a future version.)}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{na.rm}{Passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A ggproto \link[ggplot2:layer]{layer}.
}
\description{
\code{geom_unit_circle()} renders the unit circle, centered at the
origin with radius 1.
}
\section{Biplot layers}{

\code{\link[=ggbiplot]{ggbiplot()}} uses \code{\link[ggplot2:fortify]{ggplot2::fortify()}} internally to produce a single data
frame with a \code{.matrix} column distinguishing the subjects (\code{"rows"}) and
variables (\code{"cols"}). The stat layers \code{stat_rows()} and \code{stat_cols()} simply
filter the data frame to one of these two.

The geom layers \verb{geom_rows_*()} and \verb{geom_cols_*()} call the corresponding
stat in order to render plot elements for the corresponding factor matrix.
\verb{geom_dims_*()} selects a default matrix based on common practice, e.g.
points for rows and arrows for columns.
}

\section{Aesthetics}{

\code{geom_unit_circle()} understands the following aesthetics (none required):
\itemize{
\item \code{alpha}
\item \code{colour}
\item \code{linetype}
\item \code{size}
}
}

\examples{
# principal components analysis of overt & chemical diabetes test values
heplots::Diabetes[, seq(5L)] \%>\%
  princomp(cor = TRUE) \%>\%
  as_tbl_ord() \%>\%
  cbind_rows(group = heplots::Diabetes$group) \%>\%
  augment_ord() \%>\%
  print() -> diabetes_pca

# note that column standard coordinates are unit vectors
rowSums(get_cols(diabetes_pca)^2)

# plot column standard coordinates with a unit circle underlaid
diabetes_pca \%>\%
  ggbiplot(aes(label = name), sec.axes = "cols", scale.factor = 3) +
  geom_rows_point(aes(color = group), alpha = .25) +
  geom_unit_circle(alpha = .5, scale.factor = 3) +
  geom_cols_vector() +
  geom_cols_text_radiate()
}
\seealso{
Other geom layers: 
\code{\link{geom_axis}()},
\code{\link{geom_isoline}()},
\code{\link{geom_lineranges}()},
\code{\link{geom_origin}()},
\code{\link{geom_text_radiate}()},
\code{\link{geom_vector}()}
}
\concept{geom layers}
