% Generated by roxygen2 (4.0.2): do not edit by hand
\name{ore.split}
\alias{ore.split}
\title{Split strings using a regex}
\usage{
ore.split(regex, text, start = 1L, simplify = TRUE)
}
\arguments{
\item{regex}{A single character string or object of class \code{"ore"}. In
the former case, this will first be passed through \code{\link{ore}}.}

\item{text}{A vector of strings to match against.}

\item{start}{An optional vector of offsets (in characters) at which to start
searching. Will be recycled to the length of \code{text}.}

\item{simplify}{If \code{TRUE}, a character vector containing the pieces
will be returned if \code{text} is of length 1. Otherwise, a list of such
objects will always be returned.}
}
\value{
A character vector or list of substrings.
}
\description{
This function breaks up the strings provided at regions matching a regular
expression, removing those regions from the result. It is analogous to the
\code{\link{strsplit}} function in base R.
}
\examples{
ore.split("-?\\\\d+", "I have 2 dogs, 3 cats and 4 hamsters")
}
\seealso{
\code{\link{ore.search}}
}

