% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_dr_surv.r
\name{view_dr_surv}
\alias{view_dr_surv}
\title{2D or 2D view of survival data on reduced dimension}
\usage{
view_dr_surv(x, y, censor, B = NULL, bw = NULL, scale = c("log"),
  type = "2D")
}
\arguments{
\item{x}{A matrix or data.frame for features (continuous only). The algorithm will not scale the columns to unit variance}

\item{y}{A vector of observed time}

\item{censor}{A vector of censoring indicator}

\item{B}{The dimension reduction subspace, can only be 1 dimensional}

\item{bw}{A Kernel bandwidth (3D plot only) for approximating the survival function, default is the Silverman's formula}

\item{scale}{Using a transformed scale of the time \code{y}. Can be \code{none}, \code{log}, \code{loglog} or \code{root}. Default is \code{log}.}

\item{type}{\code{2D} or \code{3D} plot}
}
\description{
Produce 2D or 3D plots of right censored survival data based on a given dimension reduction space
}
\examples{
# generate some survival data
set.seed(1)
N = 350
P = 6
dataX = matrix(rnorm(N*P), N, P)
failEDR = as.matrix(cbind(c(1, 1, 0, 0, 0, 0, rep(0, P-6)),
                          c(0, 0, 1, -1, 0, 0, rep(0, P-6))))
censorEDR = as.matrix(c(0, 1, 0, 1, 1, 1, rep(0, P-6)))
T = exp(-2.5 + dataX \%*\% failEDR[,1] +
    0.5*(dataX \%*\% failEDR[,1])*(dataX \%*\% failEDR[,2]) + 0.25*log(-log(1-runif(N))))
C = exp( -0.5 + dataX \%*\% censorEDR  + log(-log(1-runif(N))))
Y = pmin(T, C)
Censor = (T < C)
view_dr_surv(dataX, Y, Censor, B = failEDR[,1], scale = "log", type = "2D")
}
\references{
Sun, Q., Zhu, R., Wang T. and Zeng D. "Counting Process Based Dimension Reduction Method for Censored Outcomes." (2017)
\url{https://arxiv.org/abs/1704.05046} .
}
