% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm-extract.R
\name{osm_polygons}
\alias{osm_polygons}
\title{Extract all \code{osm_polygons} from an osmdata object}
\usage{
osm_polygons(dat, id)
}
\arguments{
\item{dat}{An object of class \link{osmdata}}

\item{id}{OSM identification of one or more objects for which polygons are to
be extracted}
}
\value{
An \pkg{sf} Simple Features Collection of polygons
}
\description{
If \code{id} is of a point object, \code{osm_polygons} will return all
polygons containing that point. If \code{id} is of a line or polygon object,
\code{osm_polygons} will return all polygons which intersect the given line
or polygon.
}
\examples{
\dontrun{
Extract polygons which intersect Conway Street in London
dat <- opq ("Marylebone London") \%>\% add_osm_feature (key="highway") \%>\%
    osmdata_sf ()
conway <- which (dat$osm_lines$name == "Conway Street")
id <- rownames (dat$osm_lines [conway,])
osm_polygons (dat, id)
}
}
