/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.AbstractOutput;

public class SSBOutput
extends AbstractOutput {
    private double[] ssb;

    public SSBOutput(int rank) {
        super(rank);
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        this.ssb = new double[this.getNSpecies()];
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet().getAliveSchools()) {
            if (!(school.getLength() >= school.getSpecies().getSizeMaturity())) continue;
            int n = school.getSpeciesIndex();
            this.ssb[n] = this.ssb[n] + school.getInstantaneousBiomass();
        }
    }

    @Override
    public void write(float time) {
        double nsteps = this.getRecordFrequency();
        int i = 0;
        while (i < this.ssb.length) {
            int n = i++;
            this.ssb[n] = this.ssb[n] / nsteps;
        }
        this.writeVariable(time, this.ssb);
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_SSB_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        return "Spawning Stock Biomass";
    }

    @Override
    String[] getHeaders() {
        String[] species = new String[this.getNSpecies()];
        for (int i = 0; i < species.length; ++i) {
            species[i] = this.getSimulation().getSpecies(i).getName();
        }
        return species;
    }
}

