/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.process.mortality;

import fr.ird.osmose.Cell;
import fr.ird.osmose.School;
import fr.ird.osmose.Species;
import fr.ird.osmose.process.mortality.AbstractMortality;
import fr.ird.osmose.process.mortality.fishing.AbstractFishingMortality;
import fr.ird.osmose.process.mortality.fishing.AnnualFishingMortality;
import fr.ird.osmose.process.mortality.fishing.BySeasonFishingMortality;
import fr.ird.osmose.process.mortality.fishing.ByYearBySeasonFishingMortality;
import fr.ird.osmose.process.mortality.fishing.CatchesByDtByClassFishingMortality;
import fr.ird.osmose.process.mortality.fishing.RateByDtByClassFishingMortality;
import fr.ird.osmose.util.GridMap;
import fr.ird.osmose.util.MPA;
import java.util.ArrayList;
import java.util.List;

public class FishingMortality
extends AbstractMortality {
    private AbstractFishingMortality[] fishingMortality;
    private List<MPA> mpas;
    private GridMap mpaFactor;
    private Type fishingType;
    private List<School>[] arrSpecies;

    public FishingMortality(int rank) {
        super(rank);
    }

    @Override
    public void init() {
        this.fishingMortality = new AbstractFishingMortality[this.getNSpecies()];
        try {
            this.fishingType = Type.valueOf(this.getConfiguration().getString("mortality.fishing.type").toUpperCase());
        }
        catch (Exception ex) {
            this.fishingType = Type.RATE;
        }
        switch (this.fishingType) {
            case RATE: {
                Species species;
                int rank;
                for (int iSpec = 0; iSpec < this.getNSpecies(); ++iSpec) {
                    rank = this.getRank();
                    species = this.getSpecies(iSpec);
                    if (!this.getConfiguration().isNull("mortality.fishing.rate.byDt.byAge.file.sp" + iSpec) || !this.getConfiguration().isNull("mortality.fishing.rate.byDt.bySize.file.sp" + iSpec)) {
                        this.fishingMortality[iSpec] = new RateByDtByClassFishingMortality(rank, species);
                        continue;
                    }
                    if (!this.getConfiguration().isNull("mortality.fishing.rate.byYear.file.sp" + iSpec)) {
                        this.fishingMortality[iSpec] = new ByYearBySeasonFishingMortality(rank, species, Type.RATE);
                        continue;
                    }
                    if (this.getConfiguration().isNull("mortality.fishing.rate.sp" + iSpec)) continue;
                    this.fishingMortality[iSpec] = !this.getConfiguration().isNull("mortality.fishing.season.distrib.file.sp" + iSpec) ? new BySeasonFishingMortality(rank, species, Type.RATE) : new AnnualFishingMortality(rank, species, Type.RATE);
                }
                break;
            }
            case CATCHES: {
                Species species;
                int rank;
                for (int iSpec = 0; iSpec < this.getNSpecies(); ++iSpec) {
                    rank = this.getRank();
                    species = this.getSpecies(iSpec);
                    if (!this.getConfiguration().isNull("mortality.fishing.catches.byDt.byAge.file.sp" + iSpec) || !this.getConfiguration().isNull("mortality.fishing.catches.byDt.bySize.file.sp" + iSpec)) {
                        this.fishingMortality[iSpec] = new CatchesByDtByClassFishingMortality(rank, species);
                        continue;
                    }
                    if (!this.getConfiguration().isNull("mortality.fishing.catches.byYear.file.sp" + iSpec)) {
                        this.fishingMortality[iSpec] = new ByYearBySeasonFishingMortality(rank, species, Type.CATCHES);
                        continue;
                    }
                    if (this.getConfiguration().isNull("mortality.fishing.catches.sp" + iSpec)) continue;
                    this.fishingMortality[iSpec] = !this.getConfiguration().isNull("mortality.fishing.season.distrib.file.sp" + iSpec) ? new BySeasonFishingMortality(rank, species, Type.CATCHES) : new AnnualFishingMortality(rank, species, Type.CATCHES);
                }
                break;
            }
        }
        for (int iSpec = 0; iSpec < this.getNSpecies(); ++iSpec) {
            this.fishingMortality[iSpec].init();
        }
        int nMPA = this.getConfiguration().findKeys("mpa.file.mpa*").size();
        this.mpas = new ArrayList<MPA>(nMPA);
        for (int iMPA = 0; iMPA < nMPA; ++iMPA) {
            this.mpas.add(new MPA(this.getRank(), iMPA));
        }
        for (MPA mpa : this.mpas) {
            mpa.init();
        }
        this.mpaFactor = new GridMap(1);
        this.arrSpecies = new ArrayList[this.getNSpecies()];
        for (int i = 0; i < this.getNSpecies(); ++i) {
            this.arrSpecies[i] = new ArrayList<School>();
        }
    }

    public void setMPA() {
        boolean isUpToDate = true;
        int iStep = this.getSimulation().getIndexTimeSimu();
        for (MPA mPA : this.mpas) {
            isUpToDate &= mPA.isActive(iStep - 1) == mPA.isActive(iStep);
        }
        if (!isUpToDate) {
            this.mpaFactor = new GridMap(1);
            int nCellMPA = 0;
            for (MPA mpa : this.mpas) {
                if (!mpa.isActive(iStep)) continue;
                for (Cell cell : mpa.getCells()) {
                    this.mpaFactor.setValue(cell, 0.0f);
                    ++nCellMPA;
                }
            }
            int n = this.getGrid().getNOceanCell();
            float correction = (float)n / (float)(n - nCellMPA);
            for (Cell cell : this.getGrid().getCells()) {
                if (!(this.mpaFactor.getValue(cell) > 0.0f)) continue;
                this.mpaFactor.setValue(cell, correction);
            }
        }
    }

    public void assessFishableBiomass() {
        for (int i = 0; i < this.getNSpecies(); ++i) {
            this.fishingMortality[i].assessFishableBiomass();
        }
    }

    @Override
    public double getRate(School school) {
        return this.fishingMortality[school.getSpeciesIndex()].getRate(school) * (double)this.mpaFactor.getValue(school.getCell());
    }

    public double getCatches(School school) {
        double catches = this.fishingMortality[school.getSpeciesIndex()].getCatches(school) * (double)this.mpaFactor.getValue(school.getCell());
        return Math.min(catches, school.getInstantaneousBiomass());
    }

    public Type getType() {
        return this.fishingType;
    }

    public static enum Type {
        RATE,
        CATCHES;

    }
}

