% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmose-internal.R
\name{getOsmoseParameter}
\alias{getOsmoseParameter}
\title{Get a parameter from a name chain (error if not found).}
\usage{
getOsmoseParameter(par, ..., keep.att = FALSE)
}
\arguments{
\item{par}{Output of the \code{link{readOsmoseConfiguration}} function}

\item{...}{String arguments}

\item{keep.att}{Whether parameter attributes should be kept}
}
\description{
Get a parameter from a name chain (error if not found).
}
\examples{
{
   filename = system.file("extdata", "inputs/osm_all-parameters.csv", package="osmose")
   par = readOsmoseConfiguration(filename)
   getOsmoseParameter(par, "population", "seeding", "year", "max", keep.att=FALSE)
}
}
