% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/osmose-main.R
\name{runOsmose}
\alias{runOsmose}
\alias{run_osmose}
\title{Run an OSMOSE configuration}
\usage{
runOsmose(
  input,
  parameters = NULL,
  output = "output",
  log = "osmose.log",
  version = "4.1.0",
  osmose = NULL,
  java = "java",
  options = NULL,
  verbose = TRUE,
  clean = TRUE
)

run_osmose(
  input,
  parameters = NULL,
  output = NULL,
  log = "osmose.log",
  version = "3.3.3",
  osmose = NULL,
  java = "java",
  options = NULL,
  verbose = TRUE,
  clean = TRUE
)
}
\arguments{
\item{input}{Filename of the main configuration file}

\item{parameters}{Parameters to be passed to osmose (version 4 or higher).}

\item{output}{Output directory. If NULL, the value set in the configuration file is used.}

\item{log}{File to save OSMOSE execution messages.}

\item{version}{OSMOSE version. Integer (2, 3, etc.) or releases ('v3r2') are
accepted.}

\item{osmose}{Path to a OSMOSE .jar executable. By default (NULL), uses the stable 
jar for the current version.}

\item{java}{Path to the java executable. The default assumes 'java' is 
on the search path.}

\item{options}{Java options (e.g. -Xmx2048m to increase memory limit).}

\item{verbose}{Show messages? (output in the log file if FALSE).}

\item{clean}{TRUE if the output directory should be cleaned before running OSMOSE.}
}
\description{
This function create a valid configuration by several input files
from user input parameters.
}
\details{
Basic configurations may not need the use of \code{buildConfiguration},
but it is required for configuration using interannual inputs or fishing selectivity.
}
\examples{
{
  \dontrun{
    path = cacheManager("gog")
    filename = file.path(path, "osm_all-parameters.csv")
    run_osmose(filename)
  }
}
}
\author{
Ricardo Oliveros-Ramos
}
