% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmRoute.R
\name{osrmRoute}
\alias{osrmRoute}
\title{Get the Shortest Path Between Two Points}
\usage{
osrmRoute(src, dst, overview = "simplified", exclude = NULL, sp,
  returnclass)
}
\arguments{
\item{src}{a numeric vector of identifier, longitude and latitude (WGS84), a 
SpatialPointsDataFrame, a SpatialPolygonsDataFrame or an sf object of the origine 
point.}

\item{dst}{a numeric vector of identifier, longitude and latitude (WGS84), a 
SpatialPointsDataFrame, a SpatialPolygonsDataFrame or an sf object of the destination 
point.}

\item{overview}{"full", "simplified" or FALSE. Add geometry either full (detailed), simplified 
according to highest zoom level it could be display on, or not at all.}

\item{exclude}{pass an optional "exclude" request option to the OSRM API.}

\item{sp}{deprecated, if sp is TRUE the function returns a SpatialLinesDataFrame.}

\item{returnclass}{if returnclass="sf" an sf LINESTRING is returned. 
If returnclass="sp" a SpatialLineDataFrame is returned.}
}
\value{
If returnclass is not set, a data frame is returned. It contains the longitudes and latitudes of 
the travel path between the two points.\cr
If returnclass is set to "sp", a SpatialLinesDataFrame is returned. If returnclass is set to "sf", 
an sf LINESTRING is returned. It contains 4 fields : 
identifiers of origine and destination, travel time in minutes and travel distance in 
kilometers.\cr
If overview is FALSE, a named numeric vector is returned. It contains travel time (in minutes) 
and travel distance (in kilometers).
}
\description{
Build and send an OSRM API query to get the travel geometry between two points.
This function interfaces the \emph{route} OSRM service.
}
\examples{
\dontrun{
# Load data
data("berlin")
library(sf)
# Travel path between points
route1 <- osrmRoute(src = apotheke.sf[1, ], dst = apotheke.df[16, ], 
                    returnclass="sf")
# Travel path between points excluding motorways
route2 <- osrmRoute(src = apotheke.sf[1, ], dst = apotheke.df[16, ], 
                    returnclass="sf", exclude = "motorway")
# Display paths
plot(st_geometry(route1))
plot(st_geometry(route2), col = "red", add = TRUE)
plot(st_geometry(apotheke.sf[c(1,16),]), col = "red", pch = 20, add = TRUE)

# Return only duration and distance
route3 <- osrmRoute(src = apotheke.sf[1, ], dst = apotheke.df[16, ], 
                    overview = FALSE)
route3
}
}
