% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest.R
\name{nearest_api_v4}
\alias{nearest_api_v4}
\title{nearest accessible position for OSRM API v4}
\usage{
nearest_api_v4(lat, lng, address)
}
\arguments{
\item{lat, }{A numeric (-90 < lat < 90)}

\item{lng, }{A numeric (-180 < lng < 180)}

\item{address, }{A character specifying the serveraddress (local or online)}
}
\value{
A data.frame with lat and lng
}
\description{
nearest_api_v4() calculates the nearest position to the given coordinates which can be accessed
by car with the OSRM API 4. The coordinate-standard is WGS84. Attention: The OSRM API v4
is only working locally, but not with the 'OSRM' webserver.
}
\examples{
\dontrun{
Sys.setenv("OSRM_PATH_API_4"="C:/OSRM_API4")
osrmr::run_server(Sys.getenv("OSRM_PATH_API_4"), "switzerland-latest.osrm")
osrmr:::nearest_api_v4(47,9, osrmr:::server_address(TRUE))
osrmr::quit_server()
Sys.unsetenv("OSRM_PATH_API_4")}
}
