% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ot.R
\name{startSpan}
\alias{startSpan}
\alias{inject}
\alias{extract}
\title{Tracer methods}
\usage{
startSpan(tracer, name, ...)

inject(tracer, contextObj, format, carrier)

extract(tracer, format, carrier)
}
\arguments{
\item{tracer}{the tracing implementation}

\item{name}{the name of the span}

\item{...}{left to implementation}

\item{contextObj}{a span or span context}

\item{format}{One of the OpenTracing format values}

\item{carrier}{A corresponding carrier object}
}
\description{
Tracer objects encapsulate the state of the logging system. startSpan creates a span, and inject and extract set metadata via sidechannels.
}
\examples{
z <- ot::getNoOpTracer()
ot::startSpan(z)
ot::inject(z, list("User-Agent"="R"), "HTTP_HEADERS", NULL)
ot::extract(z, "HTTP_HEADERS", NULL)
}
