% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContextualAD.R
\name{ContextualAnomalyDetector}
\alias{ContextualAnomalyDetector}
\title{Contextual Anomaly Detector - Open Source (CAD)}
\usage{
ContextualAnomalyDetector(data, rest.period = max(min(150,
  round(length(data) * 0.03), 1)), max.left.semicontexts = 7,
  max.active.neurons = 15, num.norm.value.bits = 3,
  base.threshold = 0.75, min.value = min(data, na.rm = T),
  max.value = max(data, na.rm = T), python.object = NULL, lib = 0)
}
\arguments{
\item{data}{Numerical vector with training and test dataset.}

\item{rest.period}{Training period after an anomaly.}

\item{max.left.semicontexts}{Number of semicontexts that should be maintained in memory.}

\item{max.active.neurons}{Number of neurons of the model.}

\item{num.norm.value.bits}{Granularity of the transformation into discrete values}

\item{base.threshold}{Threshold to be considered an anomaly.}

\item{min.value}{Minimum expected value.}

\item{max.value}{Maximum expected value.}

\item{python.object}{Python object for incremental processing.}

\item{lib}{0 to run the original python script, 1 to get the same results on all operating
systems.}
}
\value{
List
   \item{result}{Data frame with \code{anomaly.score} and \code{is.anomaly} comparing the anomaly
    score with \code{base.threshold}.}
   \item{python.object}{ContextualAnomalyDetector Python object used in online anomaly detection}
}
\description{
\code{ContextualAnomalyDetector} calculates the anomaly score of a
dataset using the notion of contexts conformed by facts and provides
probabilistic abnormality scores.
}
\details{
\code{data} must be a numerical vector without NA values.
\code{threshold} must be a numeric value between 0 and 1. If the anomaly
score obtained for an observation is greater than the \code{threshold}, the
observation will be considered abnormal. Requires hashlib (included in python installation)
and bencode-python3 (which can be installed using pip) python libraries.
}
\examples{
## Generate data
set.seed(100)
n <- 200
x <- sample(1:100, n, replace = TRUE)
x[70:90] <- sample(110:115, 21, replace = TRUE)
x[25] <- 200
x[150] <- 170
df <- data.frame(timestamp = 1:n, value = x)

## Calculate anomalies
\donttest{
   result <- ContextualAnomalyDetector(data = df$value, rest.period = 10, base.threshold = 0.9)

   ## Plot results
   res <- cbind(df, result$result)
   PlotDetections(res, title = "CAD_OSE ANOMALY DETECTOR")
}


}
\references{
Smirnov, M. (2018). CAD: Contextual Anomaly
    Detector. https://github.com/smirmik/CAD
}
