% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numerical.R
\name{PlotNumVar}
\alias{PlotNumVar}
\title{Create plots and summary statistics for a numerical variable}
\usage{
PlotNumVar(myVar, dataFl, weightNm, dateGp, dateGpBp, skewOpt = NULL,
  kSample = 50000)
}
\arguments{
\item{myVar}{The name of the variable to be plotted}

\item{dataFl}{A \code{data.table} of data; must be the output of the
\code{\link{PrepData}} function.}

\item{weightNm}{Name of the variable containing row weights, or \code{NULL} for 
no weights (all rows receiving weight 1).}

\item{dateGp}{Name of the variable that the time series plots should be 
grouped by. Options are \code{NULL}, \code{"weeks"}, \code{"months"}, 
\code{"quarters"}, \code{"years"}. See \code{\link[data.table]{IDate}} for
details. If \code{NULL}, then \code{dateNm} will be used as \code{dateGp}.}

\item{dateGpBp}{Name of variable the boxplots should be grouped by. Same
options as \code{dateGp}. If \code{NULL}, then \code{dateGp} will be used.}

\item{skewOpt}{Either a numeric constant or \code{NULL}. Default is 
\code{NULL} (no transformation). If numeric, say 5, then all box plots of
a variable whose skewness exceeds 5 will be on a log10 scale if possible.
Negative input of \code{skewOpt} will be converted to 3.}

\item{kSample}{Either \code{NULL} or a positive integer. If an integer, 
indicates the sample size for both drawing boxplots and ordering numerical
graphs by \eqn{R^2}. When the data is large, setting \code{kSample} to a 
reasonable value (default is 50K) dramatically improves processing speed. 
Therefore, for larger datasets (e.g. > 10 percent system memory), this
parameter should not be set to \code{NULL}, or boxplots may take a very
long time to render. This setting has no impact on the accuracy of time 
series plots on quantiles, mean, SD, and missing and zero rates.}
}
\value{
\item{p}{A \code{grob} (i.e., \code{ggplot} grid) object, including a 
    side-byside boxplot grouped by \code{dateGpBp}, a time series plot of p1,
    p50 (median), and p99 grouped by \code{dateGp}, a time series plot of 
    mean and +-1 SD control limits grouped by \code{dateGp}, and a time 
    series plot of missing and zerorates grouped by \code{dateGp}.}
  \item{numVarSummary}{A \code{data.table}, contains global and over time
    summary statistics, including p1, p25, p50, p75, and p99 quantiles, mean 
    and SD, missing and zero rates.}
}
\description{
Output plots include a boxplot on the left, grouped by a courser time scale 
(\code{dateGpBp}), and three trace plots on the right, on p1, p50, 
and p99 qunatiles, mean and +-1 SD control limits, missing and zerorates,
all grouped by a finer time scale as in \code{dateGp}. In addition to plots, 
a \code{data.table} of summary statistics are generated, on global and
over time summary statistics.
}
\section{License}{

Copyright 2017 Capital One Services, LLC Licensed under the Apache License,
Version 2.0 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the  License at
http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
or agreed to in writing, software distributed under the License is 
distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
KIND, either express or implied. See the License for the specific language 
governing permissions and limitations under the License.
}

\examples{
data(bankData)
bankData <- PrepData(bankData, dateNm = "date", dateGp = "months", 
                    dateGpBp = "years")
plot(PlotNumVar("balance", bankData, NULL, "months", "years", 
                 skewOpt = NULL, kSample = NULL)$p)
}
\seealso{
Functions depend on this function:
         \code{\link{PlotVar}}.

This function depends on:
         \code{\link{SummaryStats}},
         \code{\link{PlotDist}},
         \code{\link{PlotQuantiles}},
         \code{\link{PlotMean}},
         \code{\link{PlotRates}},
         \code{\link{PrepData}}.
}
