% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_up.R
\name{tidy_up_}
\alias{tidy_up_}
\title{Tidy up owm data.}
\usage{
tidy_up_(data, flatten_weather_ = TRUE, use_underscore_ = TRUE,
  remove_prefix_ = c("main", "sys"))
}
\arguments{
\item{data}{data frame}

\item{flatten_weather_}{see \code{\link{flatten_weather}}}

\item{use_underscore_}{substitute dots in column names with underscores}

\item{remove_prefix_}{prefices to be removed for shorter column names
(\code{remove_prefix_ = NULL} will keep all prefices)}
}
\value{
updated data frame
}
\description{
Tidy up owm data.
}
\examples{
\dontrun{
   result <- find_city("Malaga")
   result$list \%>\% tidy_up_()

   # keep dots in column names
   result$list \%>\% tidy_up_(use_underscore_ = FALSE)

   # keep all prefices
   result$list \%>\% tidy_up_(remove_prefix_ = NULL)
}
}
\seealso{
\code{\link{tidy_up}},\cr
   \code{\link{remove_prefix}},\cr
   \code{\link{use_underscore}}
}

