% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OWSClient.R
\docType{class}
\name{OWSClient}
\alias{OWSClient}
\title{OWSClient}
\format{\code{\link{R6Class}} object.}
\usage{
OWSClient
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing
a Common OGC web-service.
}
\description{
OWSClient
}
\section{Fields}{

\describe{
\item{\code{url}}{the Base url of OWS service}

\item{\code{version}}{the version of OWS service}
}}

\note{
Abstract class used internally by \pkg{ows4R}
}
\section{Methods}{

\describe{
 \item{\code{new(url, service, serviceVersion, user, pwd, logger)}}{
   This method is used to instantiate a OWSClient with the \code{url} of the
   OGC service. Authentication (\code{user}/\code{pwd}) is not yet supported and will
   be added with the support of service transactional modes. By default, the \code{logger}
   argument will be set to \code{NULL} (no logger). This argument accepts two possible 
   values: \code{INFO}: to print only \pkg{ows4R} logs, \code{DEBUG}: to print more verbose logs
 }
 \item{\code{getUrl()}}{
   Get the service URL
 }
 \item{\code{getVersion()}}{
   Get the service version
 }
 \item{\code{getCapabilities()}}{
   Get the service capabilities
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Common}
\keyword{OGC}
\keyword{OWS}
