% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CASClient.R
\docType{class}
\name{CASClient}
\alias{CASClient}
\title{CASClient}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for interfacing a Central Authentication Service (CAS).
}
\description{
CASClient

CASClient
}
\note{
Class used internally by \pkg{ows4R}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Authentication}
\keyword{CAS}
\keyword{Central}
\keyword{Service}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CASClient-new}{\code{CASClient$new()}}
\item \href{#method-CASClient-getUrl}{\code{CASClient$getUrl()}}
\item \href{#method-CASClient-login}{\code{CASClient$login()}}
\item \href{#method-CASClient-logout}{\code{CASClient$logout()}}
\item \href{#method-CASClient-clone}{\code{CASClient$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CASClient-new"></a>}}
\if{latex}{\out{\hypertarget{method-CASClient-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{CASClient}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CASClient$new(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{base URL of the Central Authentication Service (CAS)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CASClient-getUrl"></a>}}
\if{latex}{\out{\hypertarget{method-CASClient-getUrl}{}}}
\subsection{Method \code{getUrl()}}{
Get CAS base URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CASClient$getUrl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the base URL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CASClient-login"></a>}}
\if{latex}{\out{\hypertarget{method-CASClient-login}{}}}
\subsection{Method \code{login()}}{
Logs in the CAS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CASClient$login(user, pwd)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{user}

\item{\code{pwd}}{password}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if logged in, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CASClient-logout"></a>}}
\if{latex}{\out{\hypertarget{method-CASClient-logout}{}}}
\subsection{Method \code{logout()}}{
Logs out from the CAS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CASClient$logout()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if logged out, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CASClient-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CASClient-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CASClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
