% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WMSCapabilities.R
\docType{class}
\name{WMSCapabilities}
\alias{WMSCapabilities}
\title{WMSCapabilities}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} with methods for interfacing an OGC
Web Map Service Get Capabilities document.
}
\description{
WMSCapabilities

WMSCapabilities
}
\note{
Class used to read a \code{WMSCapabilities} document. The use of \code{WMSClient} is
recommended instead to benefit from the full set of capabilities associated to a WMS server.
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{GetCapabilities}
\keyword{OGC}
\keyword{WMS}
\section{Super classes}{
\code{\link[ows4R:OGCAbstractObject]{ows4R::OGCAbstractObject}} -> \code{\link[ows4R:OWSCapabilities]{ows4R::OWSCapabilities}} -> \code{WMSCapabilities}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WMSCapabilities-new}{\code{WMSCapabilities$new()}}
\item \href{#method-WMSCapabilities-getRequests}{\code{WMSCapabilities$getRequests()}}
\item \href{#method-WMSCapabilities-getRequestNames}{\code{WMSCapabilities$getRequestNames()}}
\item \href{#method-WMSCapabilities-getLayers}{\code{WMSCapabilities$getLayers()}}
\item \href{#method-WMSCapabilities-findLayerByName}{\code{WMSCapabilities$findLayerByName()}}
\item \href{#method-WMSCapabilities-clone}{\code{WMSCapabilities$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="ERROR"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-ERROR'><code>ows4R::OGCAbstractObject$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="INFO"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-INFO'><code>ows4R::OGCAbstractObject$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="WARN"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-WARN'><code>ows4R::OGCAbstractObject$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="encode"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-encode'><code>ows4R::OGCAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClass"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClass'><code>ows4R::OGCAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getClassName"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getClassName'><code>ows4R::OGCAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="getNamespaceDefinition"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-getNamespaceDefinition'><code>ows4R::OGCAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="isFieldInheritedFrom"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-isFieldInheritedFrom'><code>ows4R::OGCAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="logger"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-logger'><code>ows4R::OGCAbstractObject$logger()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OGCAbstractObject" data-id="print"><a href='../../ows4R/html/OGCAbstractObject.html#method-OGCAbstractObject-print'><code>ows4R::OGCAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getClient"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getClient'><code>ows4R::OWSCapabilities$getClient()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getOWSVersion"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getOWSVersion'><code>ows4R::OWSCapabilities$getOWSVersion()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getOperationsMetadata"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getOperationsMetadata'><code>ows4R::OWSCapabilities$getOperationsMetadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getRequest"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getRequest'><code>ows4R::OWSCapabilities$getRequest()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getService"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getService'><code>ows4R::OWSCapabilities$getService()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getServiceIdentification"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getServiceIdentification'><code>ows4R::OWSCapabilities$getServiceIdentification()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getServiceProvider"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getServiceProvider'><code>ows4R::OWSCapabilities$getServiceProvider()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getServiceVersion"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getServiceVersion'><code>ows4R::OWSCapabilities$getServiceVersion()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="getUrl"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-getUrl'><code>ows4R::OWSCapabilities$getUrl()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ows4R" data-topic="OWSCapabilities" data-id="setClient"><a href='../../ows4R/html/OWSCapabilities.html#method-OWSCapabilities-setClient'><code>ows4R::OWSCapabilities$setClient()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WMSCapabilities-new"></a>}}
\if{latex}{\out{\hypertarget{method-WMSCapabilities-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{WMSCapabilities} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WMSCapabilities$new(url, version, logger = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{version}}{version}

\item{\code{logger}}{logger type \code{NULL}, "INFO" or "DEBUG"}

\item{\code{...}}{any other parameter to pass to \link{OWSGetCapabilities} service request}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WMSCapabilities-getRequests"></a>}}
\if{latex}{\out{\hypertarget{method-WMSCapabilities-getRequests}{}}}
\subsection{Method \code{getRequests()}}{
List the requests available. If \code{pretty} is TRUE,
   the output will be an object of class \code{data.frame}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WMSCapabilities$getRequests(pretty = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pretty}}{pretty}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{list} of \link{OWSRequest} available, or a \code{data.frame}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WMSCapabilities-getRequestNames"></a>}}
\if{latex}{\out{\hypertarget{method-WMSCapabilities-getRequestNames}{}}}
\subsection{Method \code{getRequestNames()}}{
List the names of requests available.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WMSCapabilities$getRequestNames()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WMSCapabilities-getLayers"></a>}}
\if{latex}{\out{\hypertarget{method-WMSCapabilities-getLayers}{}}}
\subsection{Method \code{getLayers()}}{
List the layers available. If \code{pretty} is TRUE,
   the output will be an object of class \code{data.frame}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WMSCapabilities$getLayers(pretty = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pretty}}{pretty}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{list} of \link{WMSLayer} available, or a \code{data.frame}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WMSCapabilities-findLayerByName"></a>}}
\if{latex}{\out{\hypertarget{method-WMSCapabilities-findLayerByName}{}}}
\subsection{Method \code{findLayerByName()}}{
Finds a layer by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WMSCapabilities$findLayerByName(expr, exact = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expr}}{expr}

\item{\code{exact}}{exact matching? Default is \code{TRUE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WMSCapabilities-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WMSCapabilities-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WMSCapabilities$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
