% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ozmaps-package.R
\name{abs-data}
\alias{abs-data}
\alias{abs_ced}
\alias{abs_lga}
\alias{abs_ste}
\title{Australian Bureau of Statistics (ABS) map data}
\format{
Simple features data frame with
\describe{
\item{NAME}{Area name}
\item{geometry}{Geometry column in 'sfc' format}
}
}
\description{
These data sets are simplifications of the formal statistical areas
and regions published by the ABS in 2016.
}
\details{
Each layer was read from the source file with 'sf' package and attributes were removed, leaving a single 'NAME'
column from the year-specific column names. The geometry has been
simplified using 'rmapshaper::ms_simplify' with default arguments (0.05 detail).

Several layers are not included from the total available.

The entire nation layer 'AUST' is not included
as it is the union of the State and Territory layer.

Statistical Areas Level 1 is not included as it is very large (56Mb after simplification).

The mesh blocks are not included, nor Greater Capital City Statistical Areas,
Indigenous Regions, Remoteness Structure, Statistical Areas (L2, L3, L4),
State Electoral Divisions. See 'ozmaps.data' for these.
}
\section{Data layers}{

\describe{
\item{abs_ced}{Commonwealth Electoral Divisions}
\item{abs_lga}{Local Government Areas}
\item{abs_ste}{State and Territory}
}
}

\examples{
ozmap("abs_ste")

ozmap("abs_lga", col = sample(rainbow(nrow(abs_lga), alpha = .4)))
pal <- rainbow(12, alpha = 0.6)  ## boring!  install paletteer for ochRe palettes

if (isTRUE(requireNamespace("paletteer", quietly = TRUE))) {
  if (utils::packageVersion("paletteer") < '1.0.0') {
   pal <- paletteer::paletteer_d(package = "ochRe", palette = "namatjira_qual")
 } else {
   pal <- paletteer::paletteer_d(palette = "ochRe::namatjira_qual")
 }
}
opal <- colorRampPalette(pal)
ozmap("abs_ced", col = opal(30))
}
\seealso{
The script to create the data set: data-raw/abs-inbuilt.R
}
