% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criticalVector.R
\name{criticalVector}
\alias{criticalVector}
\title{Critical vector}
\usage{
criticalVector(pvalues, family, alpha = 0.05, lambda, delta = 0, m = NULL)
}
\arguments{
\item{pvalues}{matrix of pvalues with dimensions \eqn{m \times B} used instead of the data matrix \code{X}. Default to @NULL.}

\item{family}{string character. Choose a family of confidence envelopes to compute the critical vector. 
from \code{"simes"}, \code{"aorc"}, \code{"beta"} and \code{"higher.criticism"}.}

\item{alpha}{numeric value in `[0,1]`. It expresses the alpha level to control the family-wise error rate. Default 0.05.}

\item{lambda}{numeric value. \eqn{\lambda} value computed by \code{\link{lambdaOpt}}.}

\item{delta}{numeric value. It expresses the delta value, please see the references. Default to 0.}

\item{m}{numeric value. Number of hypothesis. Default @NULL.}
}
\value{
numeric vector. Critical vector curve with length \eqn{m}.
}
\description{
Compute critical vector curve.
}
\examples{
db <- simulateData(pi0 = 0.8, m = 100, n = 20, rho = 0)
out <- signTest(X = db)
pv <- cbind(out$pv, out$pv_H0)
cv <- criticalVector(pvalues = pv, family = "simes", lambda = 0.05)
plot(sort(pv[,1]), type = "l")
lines(cv)
}
\author{
Angela Andreella
}
