% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pARI.R
\name{pARI}
\alias{pARI}
\title{Permutation-based All-Resolutions Inference}
\usage{
pARI(X= NULL, ix, alpha = 0.05, family = "simes", delta = 0, B = 1000, pvalues = NULL, 
test.type = "one_sample", complete = FALSE, clusters = FALSE, iterative = FALSE, 
approx = TRUE, ncomb = 100, step.down = FALSE, max.step = 10, ...)
}
\arguments{
\item{X}{data matrix where rows represent the \eqn{m} variables and columns the \eqn{n} observations.}

\item{ix}{numeric vector which expresses the set of hypotheses of interest. It can be a vector with length equals \eqn{m} indicating the corresponding cluster for each variable,
(in this case, you must put \code{clusters = TRUE}), or a vector containing the position indices of the variables of interest if only one set/cluster of hypotheses is considered.}

\item{alpha}{numeric value in `[0,1]`. It expresses the alpha level to control the family-wise error rate.}

\item{family}{string character. Choose a family of confidence envelopes to compute the critical vector 
from \code{"simes"}, \code{"aorc"}, \code{"beta"} and \code{"higher.criticism"}.#' @param alpha alpha level.}

\item{delta}{numeric value. It expresses the delta value, please see the references. Default to 0.}

\item{B}{numeric value. Number of permutations, default to 1000.}

\item{pvalues}{matrix of pvalues with dimensions \eqn{m \times B} used instead of the data matrix \code{X}. Default to @NULL.}

\item{test.type}{character string. Choose a type of tests among \code{"one_sample"}, i.e., one-sample t-test, or \code{"two_samples"}, i.e., two-samples t-tests. Default \code{"one_sample"}.}

\item{complete}{Boolean value. If \code{TRUE} the sets of critical vectors and the raw pvalues are returned. Default @FALSE.}

\item{clusters}{Boolean value. If \code{ix} indicates many clusters/sets must be \code{TRUE}. Default @FALSE.}

\item{iterative}{Boolean value. If \code{iterative = TRUE}, the iterative method for improvement of confidence envelopes is applied. Default @FALSE.}

\item{approx}{Boolean value. Default @TRUE. If you are treating high dimensional data, we suggest to put \code{approx = TRUE} to speed up the computation time.}

\item{ncomb}{Numeric value. If \code{approx = TRUE}, you must decide how many random subcollections (level of approximation) considered.}

\item{step.down}{Boolean value. Default @FALSE If you want to compute the lambda calibration parameter using the step-down approach put \code{TRUE}.}

\item{max.step}{Numeric value. Default to 10. Maximum number of steps for the step down approach, so useful when \code{step.down = TRUE}.}

\item{...}{Futher parameters.}
}
\value{
by default returns a list with the following objects: \code{discoveries}: lower bound for the number of true discoveries in the set selected, \code{ix}: selected variables. If \code{complete = TRUE} the raw \code{pvalues} and \code{cv} critical vector are returned.
}
\description{
The main function for All-Resolutions Inference (ARI) method based on critical vectors constructed 
using the p-values permutation distribution. The function computes simultaneous lower bounds for the number of true discoveries 
for each set of hypotheses specified in \code{ix} controlling family-wise error rate.
}
\examples{
datas <- simulateData(pi0 = 0.8, m = 1000, n = 30, power = 0.9, rho = 0,seed = 123)
out <- pARI(X = datas, ix = c(1:200),test.type = "one_sample")
out
}
\references{
For the general framework of All-Resolutions Inference see:

Goeman, Jelle J., and Aldo Solari. "Multiple testing for exploratory research." Statistical Science 26.4 (2011): 584-597.

For permutation-based All-Resolutions Inference see:

Andreella, Angela, et al. "Permutation-based true discovery proportions for fMRI cluster analysis." arXiv preprint arXiv:2012.00368 (2020).
}
\seealso{
The type of tests implemented: \code{\link{signTest}} \code{\link{permTest}}.
}
\author{
Angela Andreella
}
