#' Precipitation summary plot
#'
#' Function for plotting precipitation summary (line, matrix, box, and density)
#'
#' @import ggplot2
#' @importFrom ggpubr ggarrange
#' @param x a csv generated by \code{\link{make_ts}}
#' @param var a character string with the name of the variable to be used for the axis title
#' @param unit a character string with the variable's unit of measurement to be used for the axis title
#' @return ggplot object
#' @export

plot_summary <- function(x, var = 'Precipitation', unit = 'mm'){
  p01 <- plot_line(x, var, unit)
  p02 <- plot_heatmap(x, unit)
  p03 <- plot_box(x, var, unit)
  p04 <- plot_density(x, var, unit)
  p05 <- ggarrange(p01, p02, ncol = 1)
  p06 <- ggarrange(p03, p04, ncol = 2)
  p00 <- ggarrange(p05, p06, ncol = 1, heights = c(2, 1))
  return(p00)
}

