% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_model_functions.R
\name{populate_transition_matrix}
\alias{populate_transition_matrix}
\title{Populate transition matrix}
\usage{
populate_transition_matrix(no_states, tmat, list_prob, name_states = NULL)
}
\arguments{
\item{no_states}{number of the health states}

\item{tmat}{A transition matrix in the format from the package 'mstate'}

\item{list_prob}{list of probabilities as in the order of
transitions (row wise)}

\item{name_states}{names of the health states}
}
\value{
value of the transition matrix
}
\description{
Populate transition matrix
}
\details{
If the state names are null, they are replaced with numbers starting from 1
First find those missing probabilities, and fill a list from the given
list of probabilities and fill those are not NA in the matrix
Note that the probabilities need not be numeric here and no checks are
needed for sum
}
\examples{
tmat <- rbind(c(1, 2), c(3, 4))
colnames(tmat) <- rownames(tmat) <- c("Healthy", "Dead")
populate_transition_matrix(2, tmat, list_prob = c(0.2, 0.5, 0, 0.3))
}
