test_that("pacs::pac_timemachine", {
  skip_if_offline()
  expect_message(pac_timemachine("WRONG"), "not on CRAN")
  expect_identical(suppressMessages(pac_timemachine("WRONG")), NA)
  expect_error(pac_timemachine("dplyr", version = 2))
})

test_that("pacs::pac_timemachine online", {
  skip_if_offline()
  res <- pac_timemachine("memoise", at = as.Date("2017-02-02"))
  expect_true(isNA(res) || (res$Version == "1.0.0"))
  res <- pac_timemachine("memoise", at = as.Date("2017-02-02"), source = "cran")
  expect_true(isNA(res) || (res$Version == "1.0.0"))
  res <- pac_timemachine("memoise", from = as.Date("2017-02-02"), to = as.Date("2018-04-02"))
  expect_true(isNA(res) || (nrow(res) == 2))
  res <- pac_timemachine("memoise", from = as.Date("2017-02-02"), to = as.Date("2018-04-02"), source = "cran")
  expect_true(isNA(res) || (nrow(res) == 2))
  res <- pac_timemachine("dplyr", version = "999.1.1.1")
  expect_true(isNA(res) || (nrow(res) == 0L))
  res <- pac_timemachine("dplyr")
  expect_true(isNA(res) || (nrow(res) >= 0))
  res <- pac_timemachine("memoise", at = as.Date("2100-01-01"))
  expect_true(isNA(res) || (nrow(res) == 1))
  res <- pac_timemachine("memoise", from = as.Date("2100-01-01"), to = as.Date("2200-01-01"))
  expect_true(isNA(pac_timemachine("memoise", from = as.Date("2100-01-01"), to = as.Date("2200-01-01"))) || (nrow(res) == 1))
  expect_true(isNA(pac_archived("WRONG")))
  res <- pac_archived("dplyr")
  expect_true(isNA(res) || is.data.frame(res))
})

test_that("pacs::pac_timemachine offline", {
  pac_timemachine_offline <- pac_timemachine
  mockery::stub(pac_timemachine_offline, "is_online", FALSE)
  expect_message(pac_timemachine_offline("dplyr"), "No internet connection detected")
  expect_true(isNA(suppressMessages(pac_timemachine_offline("dplyr"))))
})
