% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q.R
\name{Q}
\alias{Q}
\title{Person Fit Index Q}
\usage{
Q(obj = NULL, data = NULL, threshold = NULL, ...)
}
\arguments{
\item{obj}{an object of class \code{"pers"} or class \code{"pair"}as a result from function \code{\link{pers}} or \code{\link{pair}} respectively.}

\item{data}{optional response data when object of class \code{"pers"} or class \code{"pair"} is not provided.}

\item{threshold}{optional in case that object of class \code{"pers"} or class \code{"pair"} is not provided. Threshold values as matrix with row and columnnames !! -- items as rows and thresholds as columns. Thresholds should be ordered from left to right, some items may have less thresholds than the others, in this case the respective row/column is filled with an NA value - see examples.}

\item{...}{not used so far.}
}
\value{
a vector holding the Q-index for every person.
}
\description{
function for calculating the person fit index Q, which was proposed by Tarnai and Rost (1990).
}
\details{
The person Q-index proposed by Tarnai and Rost, (1990) is solely based on the empirical responses and the item parameters. Thus the computation of person parameters using the function \code{\link{pers}} is not required - see examples. But for convenience return objects of both functions are accepted in function \code{Q}.
}
\examples{
#######################
data(bfiN) # get some data
ip <- pair(daten = bfiN,m = 6) # item parameters according the partial credit model
Q(ip)

### with data an thresholds as external objects #####
threshold <- matrix(seq(-3,3,length.out = 9),ncol = 3)
dimnames(threshold) <- list(c("I1","I2","I3"),c("1","2","2"))
threshold
resp_vec <- c(3,0,2,1,2,2,2,2,1,3,0,NA,NA,0,2,3,NA,2,NA,2,1,2,NA,1,2,2,NA)
resp_emp <- matrix(resp_vec,ncol = 3,byrow = TRUE)
colnames(resp_emp) <- c("I1","I2","I3")
resp_emp
Qindex <- Q(data = resp_emp,threshold = threshold)
cbind(resp_emp,Qindex)

#### unequal number of thresholds ###################
threshold <- matrix(seq(-3,3,length.out = 9),ncol = 3)
dimnames(threshold) <- list(c("I1","I2","I3"),c("1","2","2"))
threshold[2,3] <- NA

resp_vec <- c(3,0,2,1,2,2,2,2,1,3,0,NA,NA,0,2,3,NA,2,NA,2,1,2,NA,1,2,2,NA)
resp_emp <- matrix(resp_vec,ncol = 3,byrow = TRUE)
colnames(resp_emp) <- c("I1","I2","I3")
resp_emp
Qindex <- Q(data = resp_emp,threshold = threshold)
cbind(resp_emp,Qindex)
}
\references{
Tarnai, C., & Rost, J. (1990). \emph{Identifying aberrant response patterns in the Rasch model: the Q index}. Münster: ISF.
}
