% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_comparisons_caption.R
\name{pairwise_comparisons_caption}
\alias{pairwise_comparisons_caption}
\alias{pairwise_p_caption}
\title{Preparing caption in case pairwise comparisons are displayed.}
\usage{
pairwise_comparisons_caption(type, var.equal = FALSE, paired = FALSE,
  p.adjust.method = "holm", caption = NULL, ...)

pairwise_p_caption(type, var.equal = FALSE, paired = FALSE,
  p.adjust.method = "holm", caption = NULL, ...)
}
\arguments{
\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{var.equal}{a logical variable indicating whether to treat the
    two variances as being equal. If \code{TRUE} then the pooled
    variance is used to estimate the variance otherwise the Welch
    (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{p.adjust.method}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}

\item{caption}{Text to display as caption (will be displayed on top of the
description of pairwise comparison test).}

\item{...}{Current ignored.}
}
\value{
An expression containing details about the pairwise comparison test
carried out. These details are intended to be displayed in the caption of a
plot.
}
\description{
Preparing caption in case pairwise comparisons are displayed.
}
\examples{

pairwiseComparisons::pairwise_comparisons_caption(
  type = "robust",
  paired = FALSE,
  p.adjust.method = "holm",
  caption = "this is caption"
)
}
\author{
\href{https://github.com/IndrajeetPatil}{Indrajeet Patil}
}
