% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{local_deps_explain}
\alias{local_deps_explain}
\alias{local_dev_deps_explain}
\title{Explain dependencies of a package tree}
\usage{
local_deps_explain(deps, root = ".", upgrade = TRUE, dependencies = NA)

local_dev_deps_explain(deps, root = ".", upgrade = TRUE, dependencies = TRUE)
}
\arguments{
\item{deps}{Package names of the dependencies to explain.}

\item{root}{Path to the package tree.}

\item{upgrade}{Whether to use the most recent available package
versions.}

\item{dependencies}{Which dependencies to print. Defaults to the hard
dependencies for \code{local_deps()} and \code{local_deps_tree()} and the hard
dependencies plus the development dependencies for \code{local_dev_deps()}
and \code{local_dev_deps_tree()}.}
}
\description{
These functions are similar to \code{\link[=pkg_deps_explain]{pkg_deps_explain()}}, but work on a
local package tree. \code{local_dev_deps_explain()} also includes development
dependencies.
}
\seealso{
Other local package trees: 
\code{\link{local_deps}()},
\code{\link{local_install_deps}()},
\code{\link{local_install_dev_deps}()},
\code{\link{local_install}()},
\code{\link{local_package_trees}},
\code{\link{pak}()}
}
\concept{local package trees}
