% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps-explain.R
\name{pkg_deps_explain}
\alias{pkg_deps_explain}
\title{Explain how a package depends on other packages}
\usage{
pkg_deps_explain(pkg, deps, upgrade = TRUE, dependencies = NA)
}
\arguments{
\item{pkg}{Package name or remote package specification.}

\item{deps}{Package names of the dependencies to explain.}

\item{upgrade}{Whether to use the most recent available package
versions.}

\item{dependencies}{Dependency types. See
\code{\link[pkgdepends:as_pkg_dependencies]{pkgdepends::as_pkg_dependencies()}} for possible values.}
}
\value{
A named list with a print method. First entries are the
function arguments: \code{pkg}, \code{deps}, \code{dependencies}, the last one is
\code{paths} and it contains the results in a named list, the names are
the package names in \code{deps}.
}
\description{
Extract dependency chains from \code{pkg} to \code{deps}.
}
\details{
This function is similar to \code{\link[=pkg_deps_tree]{pkg_deps_tree()}}, but its output is easier
to read if you are only interested is certain packages (\code{deps}).
}
\examples{
\dontrun{
# How does the GH version of usethis depend on cli and ps?
pkg_deps_explain("r-lib/usethis", c("cli", "ps"))
}
}
