% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{pak configuration}
\alias{pak configuration}
\alias{pak-config}
\title{Environment variables and options that modify the defualt behavior}
\description{
pak behavior can be finetuned with environment variables and
options (as in \code{\link[base:options]{base::options()}}).
}
\section{R options affecting pak's behavior}{
\subsection{\code{Ncpus}}{

Set to the desired number of worker processes for package installation.
If not set, then pak will use the number of logical processors in the
machine.
}

\subsection{\code{repos}}{

The CRAN-like repositories to use. See \code{\link[base:options]{base::options()}} for details.
}
}

\section{pak configuration}{
Configuration entries (unless noted otherwise on this manual page)
have a corresponding environment variable, and a corresponding option.

The environment variable is always uppercase and uses underscores as the
word separator. It always has the \code{PKG_} prefix.

The option is typically lowercase, use it uses underscores as the word
separator, but it always has the \code{pkg.} prefix (notice the dot!).

Some examples:\tabular{lll}{
   Config entry name \tab Env var name \tab Option name \cr
   platforms \tab \code{PKG_PLATFORMS} \tab \code{pkg.platforms} \cr
   cran_mirror \tab \code{PKG_CRAN_MIRROR} \tab \code{pkg.cran_mirror} \cr
}

\subsection{pak configuration entries}{

\eval{pak:::doc_config()}
}

\subsection{Notes}{

From version 0.4.0 pak copies the \verb{PKG_*} environment variables and
the \verb{pkg.*} options to the pak subprocess, where they are actually
used, so you don't need to restart R or reaload pak after a
configuration change.
}
}

