% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{pdb.union}
\alias{pdb.union}
\title{Form the union of two occurrence data.frames or remove duplicates from occurrence data.frame. Useful if parts of a clade are not included in the downloaded dataset and need to be added separately.}
\usage{
pdb.union(x, id_col = x$occurrence_no)
}
\arguments{
\item{x}{Concatenated occurrence data.frames to be merged}

\item{id_col}{Vector or column of x containing id to be used for determining which values contain occurrence numbers to be used for matching entries}
}
\value{
A data.frame() containing the first entry for each unique occurrence to be represented in x.
}
\description{
Form the union of two occurrence data.frames or remove duplicates from occurrence data.frame. Useful if parts of a clade are not included in the downloaded dataset and need to be added separately.
}
\examples{
pdb("Stegosauria")->Stegosauria
pdb("Ankylosauria")->Ankylosauria
pdb.union(rbind(Ankylosauria, Stegosauria))->Eurypoda
}
