% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{tree.age.combine}
\alias{tree.age.combine}
\title{Combine two calibration matrixes and fill in NA values in one with values from another}
\usage{
tree.age.combine(ages0, ages1)
}
\arguments{
\item{ages0}{First matrix, NA values in which to replace with values from second matrix}

\item{ages1}{matrix from which to take replacement values}
}
\value{
A two-column matrix containing earliest and latest occurrences for each taxon in taxa, with taxon names as row names
}
\description{
Combine two calibration matrixes and fill in NA values in one with values from another
}
\details{
tree.age.combine builds the union of two calibration matrices if some of the values in one of them are NAs. If exact matches for some entries cannot be found, a relaxed search matching only the first word (i.e. usually the genus name) in each taxon name is run, in order to fill in as much of the age matrix as possible with non-NA values. It is highly recommended to manually inspect the resulting table for accuracy.
}
\examples{
data(archosauria)
data(tree_archosauria)
tree.ages.spp(tree_archosauria,data=archosauria$sptab_Ornithopoda)->ages_A
tree.ages.spp(tree_archosauria,data=archosauria$sptab_Allosauroidea)->ages_B
tree.age.combine(ages_A,ages_B)->ages
}
