% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.paleoTS}
\alias{plot.paleoTS}
\title{Plot a paleoTS object}
\usage{
\method{plot}{paleoTS}(
  x,
  nse = 1,
  pool = FALSE,
  add = FALSE,
  modelFit = NULL,
  pch = 21,
  lwd = 1.5,
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{a \code{paleoTS} object}

\item{nse}{the number of standard errors represented by the error bars on the
plot; defaults to 1}

\item{pool}{logical indicating if variances should be pooled across samples
for the purposes of displaying error bars; defaults to \code{FALSE}}

\item{add}{logical, if \code{TRUE}, adds to existing plot}

\item{modelFit}{optional model fit from fitting functions}

\item{pch}{plotting symbol, defaults to 19}

\item{lwd}{line width, defaults to 1.5}

\item{ylim}{optional, y-limits of the plot}

\item{...}{other arguments passed to plotting functions}
}
\value{
none.
}
\description{
Plot a paleoTS object
}
\examples{
x <- sim.GRW(ns = 30)
w <- fitSimple(x, model = "GRW", method = "Joint")
plot(x, modelFit = w)
}
