% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complexModels.R
\name{opt.punc}
\alias{opt.punc}
\alias{opt.joint.punc}
\title{Fit a model of trait evolution with specified punctuation(s)}
\usage{
opt.punc(
  y,
  gg,
  pool = TRUE,
  cl = list(fnscale = -1),
  meth = "L-BFGS-B",
  hess = FALSE,
  oshare
)

opt.joint.punc(
  y,
  gg,
  pool = TRUE,
  cl = list(fnscale = -1),
  meth = "L-BFGS-B",
  hess = FALSE,
  oshare
)
}
\arguments{
\item{y}{a \code{paleoTS} object}

\item{gg}{vector of indices indicating different segments}

\item{pool}{if TRUE, sample variances are substituted with their pooled estimate}

\item{cl}{optional control list, passed to \code{optim()}}

\item{meth}{optimization algorithm, passed to \code{optim()}}

\item{hess}{if TRUE, return standard errors of parameter estimates from the}

\item{oshare}{logical, if TRUE, variance assumed to be shared (equal) across segments}
}
\value{
a \code{paleoTSfit} object with the results of the model fitting
}
\description{
Fit a model of trait evolution with specified punctuation(s)
}
\details{
The sequence is divided into segments, which are separated by punctuations. Means for
each segment are given by the vector \code{theta} with variances given by the vector
\code{omega} (or a single value if \code{oshare = TRUE}). This function calls \code{optim} to numerically fit this model to a time-series, y.
}
\section{Functions}{
\itemize{
\item \code{opt.joint.punc()}: fits the punctuation model using the joint parameterization

}}
\note{
These functions would be used in the uncommon situation in which there
  is a prior hypothesis as to where the punctuation(s) take place.  Normally
  users will instead use the function \code{fitGpunc}, which uses these
  functions to fit a range of possible timings for the punctuations.
}
\examples{
x <- sim.punc(ns = c(15, 15), theta = c(0,3), omega = c(0.1, 0.1))
w.sta  <- fitSimple(x, model = "Stasis", method = "Joint")
w.punc <- opt.joint.punc(x, gg = rep(1:2, each = 15), oshare = TRUE)
compareModels(w.sta, w.punc)
}
\seealso{
\code{\link{fitGpunc}}
}
