% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfCircular.R
\name{plot.pfCircular}
\alias{plot.pfCircular}
\title{plot.pfCircular}
\usage{
\method{plot}{pfCircular}(x, ylim = NULL, xlim = NULL, ylab = NULL,
  xlab = NULL, main = NULL, text = FALSE, ...)
}
\arguments{
\item{x}{A "pfCircular" object.}

\item{ylim}{Numeric, x axis limits.}

\item{xlim}{Numeric, y axis limits.}

\item{ylab}{Character, y axis label.}

\item{xlab}{Character, x axis label.}

\item{main}{Character, title of the plot.}

\item{text}{Logical, text options.}

\item{\dots}{\dots{}}
}
\description{
Plot circular block bootstrap percentiles.
}
\examples{

ID=pfSiteSel(lat>49,lat<75,long>6,long<50)
TR1=pfTransform(ID, method=c("MinMax","Box-Cox","Z-Score"),BasePeriod=c(200,2000))

## Circular block bootstrapp
COMP=pfComposite(TR1, binning=TRUE, bins=seq(0,2000,100))
circ=pfCircular(COMP,conf=c(0.005,0.025,0.975,0.995),nboot=100)
plot(circ)

}
\author{
O. Blarquez
}

