% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfExtract.R
\name{pfExtract}
\alias{pfExtract}
\title{Extract charcoal data for a list of sites}
\usage{
pfExtract(ID)
}
\arguments{
\item{ID}{An object returned by \code{\link{pfSiteSel}}.}
}
\value{
\item{out}{A matrix of charcoal data with the following structure:
out[,1]=Site identifiers, out[,2]=Depths, out[,3]=Estimated ages,
out[,4]=Charcoal data.}
}
\description{
Extract charcoal data from an object returned by \code{\link{pfSiteSel}}
}
\examples{
\dontrun{
## Retrieve a site
ID=pfSiteSel(site_name=="Pas-de-Fond")
## Or a group of sites (Western North America)
ID=pfSiteSel(continent=="North America", long<(-100))

## Extract data
A=pfExtract(ID)

# Plot the first site raw charcoal data
plot(A[A[,1]==ID$id_site[1],3],A[A[,1]==ID$id_site[1],4],type="l",main=ID$site_name[1],
     xlab="Age",ylab="raw Char")
}
}
\author{
O. Blarquez
}
