% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2-scales.R
\name{scale_colour_palette_d}
\alias{scale_colour_palette_d}
\alias{scale_fill_palette_d}
\alias{scale_colour_palette_c}
\alias{scale_fill_palette_c}
\alias{scale_colour_palette_b}
\alias{scale_fill_palette_b}
\alias{scale_color_palette_d}
\alias{scale_color_palette_c}
\alias{scale_color_palette_b}
\title{Colour scales from colour vectors and colour palettes}
\usage{
scale_colour_palette_d(palette, direction = 1, ...)

scale_fill_palette_d(palette, direction = 1, ...)

scale_colour_palette_c(palette, direction = 1, ...)

scale_fill_palette_c(palette, direction = 1, ...)

scale_colour_palette_b(palette, direction = 1, ...)

scale_fill_palette_b(palette, direction = 1, ...)
}
\arguments{
\item{palette}{An object of class \code{palettes_palette} or \code{palettes_colour}.}

\item{direction}{Sets the order of colours in the scale. If 1, the default,
colours are ordered from first to last. If -1, the order of colours is
reversed.}

\item{...}{Other arguments passed on to \code{ggplot2::discrete_scale()},
\code{ggplot2::continuous_scale()}, or \code{ggplot2::binned_scale()} to control name,
limits, breaks, labels and so forth.}
}
\value{
A scale function that controls the mapping between data and colour or
fill aesthetics in a \link[ggplot2:ggplot2-package]{ggplot2} plot.
}
\description{
Colour scales from colour vectors and colour palettes
}
\examples{
library(ggplot2)

# Use palette_d with discrete data
discrete_pal <- pal_colour(c("#663171", "#EA7428", "#0C7156"))
ggplot(mtcars, aes(wt, mpg, colour = as.factor(cyl))) +
  geom_point(size = 3) +
  scale_colour_palette_d(discrete_pal)

# Use palette_c with continuous data
continuous_pal <- pal_colour(c("#3C0D03", "#E67424", "#F5C34D"))
ggplot(mtcars, aes(wt, mpg, colour = mpg)) +
  geom_point(size = 3) +
  scale_colour_palette_c(continuous_pal)

# Use palette_b to bin continuous data before mapping
ggplot(mtcars, aes(wt, mpg, colour = mpg)) +
  geom_point(size = 3) +
  scale_colour_palette_b(continuous_pal)
}
