% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{palettes-options}
\alias{palettes-options}
\title{Package options}
\description{
Options that adjust the behaviour of the palettes package.
}
\details{
These options can be set via \code{\link[=options]{options()}} and queried via \code{\link[=getOption]{getOption()}}.
}
\section{Options for the palettes package}{


\describe{

\item{\code{palettes.print_symbol}:}{

Character string setting the symbol used for colour previews. See
\code{\link[=list_colour_symbols]{list_colour_symbols()}} for a list of symbol choices. Defaults to
\code{"circle_small"}. Set to \code{FALSE} to disable printing symbols.

}
\item{\code{palettes.print_hex}:}{

Logical setting whether to print hex codes in colour previews. Defaults to
\code{TRUE}.

}
\item{\code{palettes.print_alpha}:}{

Logical setting whether to print the hex code alpha channel in colour
previews. Defaults to \code{FALSE}. Colours without an alpha channel will be
assumed to be full opacity.

}
\item{\code{palettes.print_sep}:}{

Character string to separate colours by in colour previews. Defaults to \code{""}.

}
\item{\code{palettes.print_width}:}{

Integer setting the maximum number of colours on a line in colour previews.
Defaults to \code{1}.

}
\item{\code{palettes.print_index}:}{

Logical setting whether to print the index of the first colour on each line
in colour previews. Defaults to \code{FALSE}.

}

}
}

\section{Note}{

To disable formatting in colour previews set both \code{palettes.print_symbol} and
\code{palettes.print_hex} to \code{FALSE}.
}

\examples{
options(
  palettes.print_symbol = "square",
  palettes.print_hex = FALSE,
  palettes.print_sep = " ",
  palettes.print_width = 3,
  palettes.print_index = TRUE
)
met_palettes$Cross
}
