% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pals.R
\docType{package}
\name{pals}
\alias{pals}
\alias{pals-package}
\title{pals: A package for comprehensive palettes and palette evaluation tools}
\description{
pals: A package for comprehensive palettes and palette evaluation tools
}
\details{
The terms 'palette' and 'colormap' are often interchanged. In this package
(1) 'palette' is usually a discrete set of distinct colors and
(2) 'colormap' is usually a smoothly varying set of many colors.

The best palette/colormap is determined by
(1) the type of structure in the data,
(2) the type of graphic to be constructed, and
(3) the type of device used to show the graphic.
The ColorBrewer website approaches this problem by suggesting different
colors for qualitative, sequential, and divergining data, and also
considers the display of the graphic on LCD and photocopies.
One limitation with ColorBrewer is that it only uses maps, and does not
consider other types of graphics.
For example, yellow colors work well for polygons (on maps, barcharts, etc),
but are poor for lines and scatter plots.

The 'pals' package provides a suite of tools to evaluate palettes/colormaps.

The design goals of the package are:
\itemize{

\item
All palettes/colormaps are functions that return a vector of colors.

\item
The palette function names use only lowercase letters.

\item
The 'data' directory is not used.

\item
Provide an extensive collection of palettes and colormaps.

\item
Be memory efficient.  Colormaps are compressed.

\item
Provide multiple tools to evaluate palettes.
}

To learn more, see the vignettes:
\code{browseVignettes(package="pals")}
}
