% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_frame.R
\name{model_frame}
\alias{model_frame}
\title{Make model frames for panel_data objects}
\usage{
model_frame(formula, data)
}
\arguments{
\item{formula}{A formula. Note that to get an individual-level mean with
incomplete data (e.g., panel attrition), you should use \code{imean()} rather
than \code{mean()}.}

\item{data}{A \code{\link[=panel_data]{panel_data()}} frame.}
}
\value{
A \code{\link[=panel_data]{panel_data()}} frame with only the columns needed to fit
a model as described by the formula.
}
\description{
This is similar to model.frame, but is designed specifically
for \code{\link[=panel_data]{panel_data()}} data frames. It's a workhorse in \code{\link[=wbm]{wbm()}}
but may be useful in scripting use as well.
}
\examples{

data("WageData")
wages <- panel_data(WageData, id = id, wave = t)
model_frame(lwage ~ wks + exp, data = wages)

}
