% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bar.R
\name{Bar}
\alias{Bar}
\title{Bar}
\description{
This is an abstract class that defines the pure virtual methods a concrete
bar must implement.
}
\details{
This class cannot be instantiated. It needs to be extended by concrete
subclasses that implement the pure virtual methods. Instances of concrete
backend implementations can be conveniently obtained using the
\code{\link{BarFactory}} class.
}
\seealso{
\code{\link{BasicBar}}, \code{\link{ModernBar}}, and \code{\link{BarFactory}}.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{engine}}{The bar engine.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Bar-new}{\code{Bar$new()}}
\item \href{#method-Bar-create}{\code{Bar$create()}}
\item \href{#method-Bar-update}{\code{Bar$update()}}
\item \href{#method-Bar-terminate}{\code{Bar$terminate()}}
\item \href{#method-Bar-clone}{\code{Bar$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Bar-new"></a>}}
\if{latex}{\out{\hypertarget{method-Bar-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{\link{Bar}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bar$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Instantiating this call will throw an error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Bar-create"></a>}}
\if{latex}{\out{\hypertarget{method-Bar-create}{}}}
\subsection{Method \code{create()}}{
Create a progress bar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bar$create(total, initial, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{total}}{The total number of times the progress bar should tick.}

\item{\code{initial}}{The starting point of the progress bar.}

\item{\code{...}}{Additional arguments for the bar creation. See the
\strong{Details} section for more information.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The optional \code{...} named arguments depend on the specific concrete
implementation (i.e., \code{\link{BasicBar}} or
\code{\link{ModernBar}}).
}

\subsection{Returns}{
This method returns void. The resulting bar is stored in the private
field \code{.bar}, accessible via the active binding \code{engine}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Bar-update"></a>}}
\if{latex}{\out{\hypertarget{method-Bar-update}{}}}
\subsection{Method \code{update()}}{
Update the progress bar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bar$update(current)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{current}}{The position the progress bar should be at (e.g., 30
out of 100), usually the index in a loop.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Bar-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-Bar-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate the progress bar.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bar$terminate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Bar-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Bar-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Bar$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
