% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SessionState.R
\name{SessionState}
\alias{SessionState}
\title{SessionState}
\description{
This class holds the state of a background \code{\link[callr:r_session]{session}}
used by an asynchronous backend (i.e., \code{\link{AsyncBackend}}). See the
\strong{Details} section for more information.
}
\details{
The session state is useful to check if an asynchronous backend is ready for
certain operations. A session can only be in one of the following four states
at a time:
\itemize{
\item \code{session_is_starting}: When \code{TRUE}, it indicates that the session is
starting.
\item \code{session_is_idle}: When \code{TRUE}, it indicates that the session is idle and
ready to execute operations.
\item \code{session_is_busy}: When \code{TRUE}, it indicates that the session is busy
(i.e., see the \code{\link{TaskState}} class for more information about a
task's state).
\item \code{session_is_finished}: When \code{TRUE}, it indicates that the session is closed
and no longer available for operations.
}
}
\examples{
# Handy function to print the session states all at once.
check_state <- function(session) {
    # Create a session object and determine its state.
    session_state <- SessionState$new(session)

    # Print the state.
    cat(
        "Session is starting: ", session_state$session_is_starting, "\n",
        "Session is idle: ", session_state$session_is_idle, "\n",
        "Session is busy: ", session_state$session_is_busy, "\n",
        "Session is finished: ", session_state$session_is_finished, "\n",
        sep = ""
    )
}

# Create a specification object.
specification <- Specification$new()

# Set the number of cores.
specification$set_cores(cores = 2)

# Set the cluster type.
specification$set_type(type = "psock")

# Create an asynchronous backend object.
backend <- AsyncBackend$new()

# Start the cluster on the backend.
backend$start(specification)

# Check that the session is idle.
check_state(backend$cluster)

{
    # Run a task in parallel (i.e., approx. 0.25 seconds).
    backend$sapply(
        x = 1:10,
        fun = function(x) {
            # Sleep a bit.
            Sys.sleep(0.05)

            # Compute something.
            output <- x + 1

            # Return the result.
            return(output)
        }
    )

    # And immediately check that the session is busy.
    check_state(backend$cluster)
}

# Get the output and wait for the task to complete.
output <- backend$get_output(wait = TRUE)

# Check that the session is idle again.
check_state(backend$cluster)

# Manually close the session.
backend$cluster$close()

# Check that the session is finished.
check_state(backend$cluster)

# Stop the backend.
backend$stop()

}
\seealso{
\code{\link{TaskState}}, \code{\link{AsyncBackend}} and
\code{\link{ProgressTrackingContext}}.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{session_is_starting}}{A logical value indicating whether the
session is starting.}

\item{\code{session_is_idle}}{A logical value indicating whether the session
is idle and ready to execute operations.}

\item{\code{session_is_busy}}{A logical value indicating whether the session
is busy.}

\item{\code{session_is_finished}}{A logical value indicating whether the
session is closed and no longer available for operations.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SessionState-new}{\code{SessionState$new()}}
\item \href{#method-SessionState-clone}{\code{SessionState$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SessionState-new"></a>}}
\if{latex}{\out{\hypertarget{method-SessionState-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{\link{SessionState}} object and determine the state
of a given background \code{\link[callr:r_session]{session}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SessionState$new(session)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A \code{\link[callr:r_session]{callr::r_session}} object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{SessionState}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SessionState-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SessionState-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SessionState$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
